
<?php
header('Content-Type: text/html; charset=utf-8');

// ================= تنظیمات ملی پیامک =================
$username = "USERNAME";     // نام کاربری ملی پیامک
$password = "PASSWORD";     // رمز/API Key
$bodyId   = "12345";        // ID پترن {text}

// ================= دریافت اطلاعات فرم =================
$mobile = isset($_POST['mobile']) ? trim($_POST['mobile']) : '';
$text   = isset($_POST['text']) ? trim($_POST['text']) : '';

if ($mobile == '' || $text == '') {
    die('❌ شماره یا متن پیامک خالی است');
}

// ================= اعتبارسنجی شماره =================
if (!preg_match('/^09\d{9}$/', $mobile)) {
    die('❌ شماره گیرنده معتبر نیست. باید 09xxxxxxxxx باشد');
}

// ================= جایگزینی متغیرها =================
$replacements = [
    '{code}' => '1234',
    '{order_id}' => '9876'
];
$text = strtr($text, $replacements);

// ================= آماده‌سازی داده =================
$data = [
    "username" => $username,
    "password" => $password,
    "to"       => $mobile,
    "bodyId"   => $bodyId,
    "text"     => $text
];

// ================= ارسال پیامک =================
$ch = curl_init("https://rest.payamak-panel.com/api/SendSMS/BaseServiceNumber");
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);

$response = curl_exec($ch);

if ($response === false) {
    die('❌ خطای CURL: ' . curl_error($ch));
}

curl_close($ch);

// ================= بررسی نتیجه =================
$result = json_decode($response, true);

if (isset($result['RetStatus']) && $result['RetStatus'] == 1) {
    echo "✅ پیامک با موفقیت ارسال شد";
} else {
    echo "❌ خطا در ارسال پیامک<br><pre>";
    print_r($result);
    echo "</pre>";
}
?>
